<?php


use App\Http\Controllers\HomeController;

use App\Http\Controllers\CourseController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\CategoryController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/



Auth::routes();

Route::get('/clear-cache', function () {

  Artisan::call('cache:clear');

  Artisan::call('optimize:clear');

  Artisan::call('config:cache');

  return 'Cache cleared, optimized, and .env file refreshed successfully.';
});


Route::get('/', [HomeController::class, 'index'])->name('index');
Route::get('/about', [HomeController::class, 'about'])->name('about');
Route::get('/contact', [HomeController::class, 'contact']);
Route::get('/data/{type}/{catid?}/{subcatid?}', [HomeController::class, 'course'])->name('data');
Route::get('/details/{type}/{slug}', [HomeController::class, 'courseDetails'])->name('details');
Route::post('/contact-us', [HomeController::class, 'contactUs'])->name('contact-us');
Route::get('/assignment/upload', [CourseController::class, 'AssignmentUpload'])->name('assignment.upload');
Route::post('/assignment/upload', [CourseController::class, 'AssignmentUploadSave'])->name('assignment.upload.save');
Route::get('dashboard/subcategories/{category_id}', [CourseController::class, 'subcategories']);



// Route::group(['middleware'=>'auth'],function(){

//   Route::controller(DashboardController::class)->group(function(){
//       Route::get('/home','Home')->name('home');      
//    });

//   });


Route::group(['middleware' => 'auth', 'prefix' => 'dashboard', 'as' => 'dashboard.'], function () {


  Route::controller(CourseController::class)->group(function () {
    Route::get('/course', 'Course')->name('course');
    Route::get('/course/add', 'CourseAdd')->name('course.add');
    Route::post('/course/save', 'CourseSave')->name('course.save');
    Route::get('/course/edit/{id}', 'CourseEdit')->name('course.edit');
    Route::post('/course/update', 'CourseUpdate')->name('course.update');
    Route::post('/course/delete', 'CourseDelete')->name('course.delete');
    Route::get('/', 'Assignment')->name('assignment');
    Route::get('/assignment/add', 'AssignmentAdd')->name('assignment.add');
    Route::get('/assignment/edit/{id}', 'AssignmentEdit')->name('assignment.edit');



    Route::get('/uploaded/assignment/list', 'UploadedAssignmentList')->name('uploaded.assignment.list');
    Route::post('/uploaded/assignment/delete', 'UploadedAssignmentDelete')->name('uploaded.assignment.delete');
  });




  Route::controller(ContactController::class)->group(function () {
    Route::get('/contact', 'Contact')->name('contact');
  });

  Route::controller(CategoryController::class)->group(function () {
    Route::get('/category', 'Category')->name('category');
    Route::get('/category/add', 'CategoryAdd')->name('category.add');
    Route::post('/category/save', 'CategorySave')->name('category.save');
    Route::get('/category/edit/{id}', 'CategoryEdit')->name('category.edit');
    Route::post('/category/update', 'CategoryUpdate')->name('category.update');
    Route::post('/category/delete', 'CategoryDelete')->name('category.delete');

    Route::get('/subcategory', 'Subcategory')->name('subcategory');
    Route::get('/subcategory/add', 'SubcategoryAdd')->name('subcategory.add');
    Route::post('/subcategory/save', 'SubcategorySave')->name('subcategory.save');
    Route::get('/subcategory/edit/{id}', 'SubcategoryEdit')->name('subcategory.edit');
    Route::post('/subcategory/update', 'SubcategoryUpdate')->name('subcategory.update');
    Route::post('/subcategory/delete', 'SubcategoryDelete')->name('subcategory.delete');
  });
});
