<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- awesone fonts css-->
    <link href="{{ asset('front/css/font-awesome.css') }}" rel="stylesheet" type="text/css">
    <!-- owl carousel css-->
    <link rel="stylesheet" href="{{ asset('front/owl-carousel/assets/owl.carousel.min.css') }}" type="text/css">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{ asset('front/css/bootstrap.min.css') }}">
    <!-- custom CSS -->
    <link rel="stylesheet" href="{{ asset('front/css/style.css') }}">
    <link rel="stylesheet" href="{{ asset('front/css/custom.css') }}">

    <title>GRIVA SERVICES </title>
    <style>
        .dropdown-submenu {
            position: relative;
        }

        .dropdown-submenu .dropdown-menu {
            top: 0;
            left: 100%;
            margin-top: -1px;
        }

        .dropdown-submenu:hover .dropdown-menu {
            display: block;
        }

        .dropdown-submenu:hover .dropdown-toggle::after {
            transform: rotate(-90deg);
        }

        .dropdown-menu {
            margin-top: 0;
            border: none;
        }

        .dropdown-divider {
            margin: 0;
        }

        .dropdown-item:hover,
        .dropdown-item:focus {
            color: #fff !important;
            background: linear-gradient(to right, #1d3ede, #01e6f8);
        }
    </style>
    @stack('styles')
</head>

<body>
    <nav class="navbar navbar-expand-lg navbar-light bg-light bg-transparent" id="gtco-main-nav">
        <div class="container">
            <a class="navbar-brand">Griva services</a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#my-nav"
                aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="my-nav">
                <ul class="navbar-nav mr-auto">
                    <li class="nav-item active">
                        <a class="nav-link" href="{{ route('index') }}">Home <span class="sr-only">(current)</span></a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownCourse" role="button"
                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Course
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdownCourse">

                            @php
                                $categories = App\Models\Category::whereStatus('1')->whereType('course')->get();
                            @endphp

                            @foreach ($categories as $category)
                                @if ($category->subcategories->isNotEmpty())
                                    <div class="dropdown-submenu">
                                        <a class="dropdown-item dropdown-toggle"
                                            href="{{ route('data', ['type' => 'course', 'catid' => $category->id]) }}">{{ $category->name }}</a>

                                        <div class="dropdown-menu">
                                            @foreach ($category->subcategories as $subcategory)
                                                <a class="dropdown-item"
                                                    href="{{ route('data', ['type' => 'course', 'catid' => $category->id, 'subcatid' => $subcategory->id]) }}">{{ $subcategory->name }}
                                                </a>
                                            @endforeach
                                        </div>

                                    </div>
                                @else
                                    <a class="dropdown-item"
                                        href="{{ route('data', ['type' => 'course', 'catid' => $category->id]) }}">{{ $category->name }}</a>
                                @endif
                            @endforeach

                        </div>
                    </li>

                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownAssignment" role="button"
                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Assignment
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdownAssignment">

                            @php
                                $categories = App\Models\Category::whereStatus('1')->whereType('assignment')->get();
                            @endphp

                            @foreach ($categories as $category)
                                @if ($category->subcategories->isNotEmpty())
                                    <div class="dropdown-submenu">
                                        <a class="dropdown-item dropdown-toggle"
                                            href="{{ route('data', ['type' => 'assignment', 'catid' => $category->id]) }}">{{ $category->name }}</a>

                                        <div class="dropdown-menu">
                                            @foreach ($category->subcategories as $subcategory)
                                                <a class="dropdown-item"
                                                    href="{{ route('data', ['type' => 'assignment', 'catid' => $category->id, 'subcatid' => $subcategory->id]) }}">{{ $subcategory->name }}
                                                </a>
                                            @endforeach
                                        </div>

                                    </div>
                                @else
                                    <a class="dropdown-item"
                                        href="{{ route('data', ['type' => 'assignment', 'catid' => $category->id]) }}">{{ $category->name }}</a>
                                @endif
                            @endforeach

                        </div>
                    </li>


                    <li class="nav-item">
                        <a class="nav-link about-link" href="{{ route('about') }}">About</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('assignment.upload') }}" style="color: white">Assignment
                            Upload</a>
                    </li>
                </ul>
                <form class="form-inline my-2 my-lg-0">
                    <a href="#contact" class="btn btn-outline-dark my-2 my-sm-0 mr-3 text-uppercase">CONTACT US</a>
                </form>
            </div>
        </div>
    </nav>



    @yield('content')


    <footer class="container-fluid mt-5" id="gtco-footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-6" id="contact">
                    <h4>Contact Us</h4>
                    <form method="POST" action="{{ route('contact-us') }}">
                        @csrf
                        <input type="hidden" name="form_source" value="footer">

                        <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                            placeholder="Full Name" value="{{ old('form_source') == 'footer' ? old('name') : '' }}">

                        @if ($errors->has('name') && old('form_source') == 'footer')
                            <span class="invalid-feedbackk" role="alert">
                                <strong>{{ $errors->first('name') }}</strong>
                            </span>
                        @endif

                        <input type="email" name="email" class="form-control @error('email') is-invalid @enderror"
                            placeholder="Email Address"
                            value="{{ old('form_source') == 'footer' ? old('email') : '' }}">
                        @if ($errors->has('email') && old('form_source') == 'footer')
                            <span class="invalid-feedbackk" role="alert">
                                <strong>{{ $errors->first('email') }}</strong>
                            </span>
                        @endif

                        <input type="number" name="contact_number"
                            class="form-control @error('contact_number') is-invalid @enderror" placeholder="Mobile no"
                            value="{{ old('form_source') == 'footer' ? old('contact_number') : '' }}">
                        @if ($errors->has('contact_number') && old('form_source') == 'footer')
                            <span class="invalid-feedbackk" role="alert">
                                <strong>{{ $errors->first('contact_number') }}</strong>
                            </span>
                        @endif


                        <textarea name="description" class="form-control @error('description') is-invalid @enderror" placeholder="Message">{{ old('form_source') == 'footer' ? old('description') : '' }}</textarea>
                        @if ($errors->has('description') && old('form_source') == 'footer')
                            <span class="invalid-feedbackk" role="alert">
                                <strong>{{ $errors->first('description') }}</strong>
                            </span>
                        @endif




                        @if (session('status') == 'success' && session('form_source') == 'footer')
                            <div class="alert alert-success" role="alert">
                                {{ session('message') }}
                            </div>
                        @endif

                        <button type="submit" class="submit-button">SUBMIT <i class="fa fa-angle-right"
                                aria-hidden="true"></i></button>
                    </form>
                </div>

                <div class="col-lg-6">
                    <div class="row">
                        <div class="col-6">
                            <h4>Company</h4>
                            <ul class="nav flex-column company-nav">
                                <li class="nav-item"><a class="nav-link" href="{{ route('index') }}">Home</a></li>
                                <li class="nav-item"><a class="nav-link" href="{{ route('about') }}">About</a></li>
                                <li class="nav-item"><a class="nav-link" href="#contact">Contact</a></li>
                            </ul>
                            <h4 class="mt-5">Fllow Us</h4>
                            <ul class="nav follow-us-nav">
                                <li class="nav-item"><a class="nav-link pl-0" href="#"><i
                                            class="fa fa-facebook" aria-hidden="true"></i></a></li>
                                <li class="nav-item"><a class="nav-link" href="#"><i class="fa fa-twitter"
                                            aria-hidden="true"></i></a></li>
                                <li class="nav-item"><a class="nav-link" href="#"><i class="fa fa-google"
                                            aria-hidden="true"></i></a></li>
                                <li class="nav-item"><a class="nav-link" href="#"><i class="fa fa-linkedin"
                                            aria-hidden="true"></i></a></li>
                            </ul>
                        </div>
                        <div class="col-6">
                            <h4>Services</h4>
                            <ul class="nav flex-column services-nav">
                                <li class="nav-item"><a class="nav-link" href="#">Assignment</a></li>
                                <li class="nav-item"><a class="nav-link" href="#">Graphics Design</a></li>
                                <li class="nav-item"><a class="nav-link" href="#">App Design</a></li>
                                <li class="nav-item"><a class="nav-link" href="#">SEO</a></li>
                                <li class="nav-item"><a class="nav-link" href="#">Marketing</a></li>
                            </ul>
                        </div>
                        <div class="col-12">
                            <p>&copy; {{ date('Y') }}. All Rights Reserved.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Optional JavaScript -->
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="{{ asset('front/js/jquery-3.3.1.slim.min.js') }}"></script>
    <script src="{{ asset('front/js/popper.min.js') }}"></script>
    <script src="{{ asset('front/js/bootstrap.min.js') }}"></script>
    <!-- owl carousel js-->
    <script src="{{ asset('front/owl-carousel/owl.carousel.min.js') }}"></script>
    <script src="{{ asset('front/js/main.js') }}"></script>
    <script>
        $(document).ready(function() {
            // Close dropdowns when clicking outside
            $(document).on('click', function(e) {
                if (!$(e.target).closest('.dropdown').length) {
                    $('.dropdown-menu').removeClass('show');
                }
            });

            $('.dropdown-menu').on('click', function(e) {
                if ($(e.target).hasClass('dropdown-toggle')) {
                    var $submenu = $(e.target).next('.dropdown-menu');
                    if ($submenu.hasClass('show')) {
                        $submenu.removeClass('show');
                    } else {
                        $(this).find('.dropdown-menu').removeClass('show');
                        $submenu.addClass('show');
                    }
                }
            });
        });
    </script>
</body>

</html>


@stack('scripts')
