@extends('layouts.app')

@section('content')
    <div class="container-fluid gtco-banner-area">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h1>
                        Welcome to <span> Griva Services</span> </h1>
                    <p>At Griva Services, we're dedicated to providing top-tier academic support tailored to your needs.
                        With over six years of expertise in the industry, our seasoned professionals guarantee precise
                        guidance at competitive prices. </p>
                    <a href="#contact">Contact Us <i class="fa fa-angle-right" aria-hidden="true"></i></a>
                </div>
                <div class="col-md-6">
                    <div class="card"><img class="card-img-top img-fluid" src="{{ asset('front/images/banner-img.png') }}"
                            alt=""></div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid gtco-feature" id="services">
        <div class="container">
            <div class="row">
                <div class="col-md-7">
                    <div class="cover">
                        <div class="card">
                            <svg class="back-bg" width="100%" viewBox="0 0 900 700"
                                style="position:absolute; z-index: -1">
                                <defs>
                                    <linearGradient id="PSgrad_01" x1="64.279%" x2="0%" y1="76.604%"
                                        y2="0%">
                                        <stop offset="0%" stop-color="rgb(1,230,248)" stop-opacity="1" />
                                        <stop offset="100%" stop-color="rgb(29,62,222)" stop-opacity="1" />
                                    </linearGradient>
                                </defs>
                                <path fill-rule="evenodd" opacity="0.102" fill="url(#PSgrad_01)"
                                    d="M616.656,2.494 L89.351,98.948 C19.867,111.658 -16.508,176.639 7.408,240.130 L122.755,546.348 C141.761,596.806 203.597,623.407 259.843,609.597 L697.535,502.126 C748.221,489.680 783.967,441.432 777.751,392.742 L739.837,95.775 C732.096,35.145 677.715,-8.675 616.656,2.494 Z" />
                            </svg>
                            <!-- *************-->

                            <svg width="100%" viewBox="0 0 700 500">
                                <clipPath id="clip-path">
                                    <path
                                        d="M89.479,0.180 L512.635,25.932 C568.395,29.326 603.115,76.927 590.357,129.078 L528.827,380.603 C518.688,422.048 472.661,448.814 427.190,443.300 L73.350,400.391 C32.374,395.422 -0.267,360.907 -0.002,322.064 L1.609,85.154 C1.938,36.786 40.481,-2.801 89.479,0.180 Z">
                                    </path>
                                </clipPath>
                                <!-- xlink:href for modern browsers, src for IE8- -->
                                <image clip-path="url(#clip-path)" xlink:href="{{ asset('front/images/learn-img.jpg') }}"
                                    width="100%" height="465" class="svg__image"></image>
                            </svg>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                    <h2> Griva Services, Your Trusted Academic Support Partner</h2>
                    <p>Griva Services, with over six years of expertise, provides tailored academic solutions from research
                        mastery to essay refinement. </p>
                    <p>
                        <small>Our seasoned professionals ensure seamless communication and exceptional results, committed
                            to your academic success.
                        </small>
                    </p>
                    <a href="#contact">Contact us <i class="fa fa-angle-right" aria-hidden="true"></i></a>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid gtco-features" id="about">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <h2>
                        Explore Our Services </h2>
                    <p> Embark on a journey of academic excellence with Griva Services. Our tailored solutions cater to your
                        educational needs, ensuring precision and professionalism every step of the way. </p>
                    <a href="#contact">Contact Us <i class="fa fa-angle-right" aria-hidden="true"></i></a>
                </div>
                <div class="col-lg-8">
                    <svg id="bg-services" width="100%" viewBox="0 0 1000 800">
                        <defs>
                            <linearGradient id="PSgrad_02" x1="64.279%" x2="0%" y1="76.604%" y2="0%">
                                <stop offset="0%" stop-color="rgb(1,230,248)" stop-opacity="1" />
                                <stop offset="100%" stop-color="rgb(29,62,222)" stop-opacity="1" />
                            </linearGradient>
                        </defs>
                        <path fill-rule="evenodd" opacity="0.102" fill="url(#PSgrad_02)"
                            d="M801.878,3.146 L116.381,128.537 C26.052,145.060 -21.235,229.535 9.856,312.073 L159.806,710.157 C184.515,775.753 264.901,810.334 338.020,792.380 L907.021,652.668 C972.912,636.489 1019.383,573.766 1011.301,510.470 L962.013,124.412 C951.950,45.594 881.254,-11.373 801.878,3.146 Z" />
                    </svg>
                    <div class="row">
                        <div class="col">
                            <div class="card text-center">
                                <div class="oval"><img class="card-img-top"
                                        src="{{ asset('front/images/web-design.png') }}" alt=""></div>
                                <div class="card-body">
                                    <h3 class="card-title">Research Assistance</h3>
                                    <p class="card-text">Master the art of online research across various academic levels,
                                        from diploma to postgraduate courses.</p>
                                </div>
                            </div>
                            <div class="card text-center">
                                <div class="oval"><img class="card-img-top"
                                        src="{{ asset('front/images/marketing.png') }}" alt=""></div>
                                <div class="card-body">
                                    <h3 class="card-title">Proofreading Services</h3>
                                    <p class="card-text">Refine your grammar and sentence structure with our professional
                                        proofreading services.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card text-center">
                                <div class="oval"><img class="card-img-top" src="{{ asset('front/images/seo.png') }}"
                                        alt=""></div>
                                <div class="card-body">
                                    <h3 class="card-title">Dissertation Help</h3>
                                    <p class="card-text">Receive nothing short of exceptional service with our high-quality
                                        dissertation assistance.</p>
                                </div>
                            </div>
                            <div class="card text-center">
                                <div class="oval"><img class="card-img-top"
                                        src="{{ asset('front/images/graphics-design.png') }}" alt=""></div>
                                <div class="card-body">
                                    <h3 class="card-title">Data Analysis</h3>
                                    <p class="card-text">Enhance your analytical skills with guidance from our proficient
                                        experts.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid gtco-numbers-block">
        <div class="container">
            <svg width="100%" viewBox="0 0 1600 400">
                <defs>
                    <linearGradient id="PSgrad_03" x1="80.279%" x2="0%" y2="0%">
                        <stop offset="0%" stop-color="rgb(1,230,248)" stop-opacity="1" />
                        <stop offset="100%" stop-color="rgb(29,62,222)" stop-opacity="1" />

                    </linearGradient>

                </defs>
                <!-- <clipPath id="clip-path3">

                                                                                          </clipPath> -->

                <path fill-rule="evenodd" fill="url(#PSgrad_03)"
                    d="M98.891,386.002 L1527.942,380.805 C1581.806,380.610 1599.093,335.367 1570.005,284.353 L1480.254,126.948 C1458.704,89.153 1408.314,59.820 1366.025,57.550 L298.504,0.261 C238.784,-2.944 166.619,25.419 138.312,70.265 L16.944,262.546 C-24.214,327.750 12.103,386.317 98.891,386.002 Z">
                </path>

                <clipPath id="ctm" fill="none">
                    <path
                        d="M98.891,386.002 L1527.942,380.805 C1581.806,380.610 1599.093,335.367 1570.005,284.353 L1480.254,126.948 C1458.704,89.153 1408.314,59.820 1366.025,57.550 L298.504,0.261 C238.784,-2.944 166.619,25.419 138.312,70.265 L16.944,262.546 C-24.214,327.750 12.103,386.317 98.891,386.002 Z">
                    </path>
                </clipPath>

                <!-- xlink:href for modern browsers, src for IE8- -->
                <image clip-path="url(#ctm)" xlink:href="{{ asset('front/images/word-map.png') }}" height="800px"
                    width="100%" class="svg__image">

                </image>

            </svg>
            <div class="row">
                <div class="col-3">
                    <div class="card">
                        <div class="card-body  learning-card">
                            <p class="card-text">Engaged Learning</p>
                            <h6 class="card-title learn-lext">Dive into a multitude of ongoing projects tailored to your
                                academic
                                pursuits and goals.</h6>
                        </div>
                    </div>
                </div>
                <div class="col-3">
                    <div class="card">
                        <div class="card-body learning-card">
                            <p class="card-text">Satisfied Success</p>
                            <h6 class="card-title learn-lext">Join our community of contented clients who have experienced
                                remarkable
                                progress and fulfillment in their academic journey</h6>
                        </div>
                    </div>
                </div>
                <div class="col-3">
                    <div class="card">
                        <div class="card-body learning-card">
                            <p class="card-text">Strategic Advancement</p>
                            <h6 class="card-title learn-lext">Partner with us to witness your academic endeavors flourish
                                and expand
                                beyond expectations.</h6>
                        </div>
                    </div>
                </div>
                <div class="col-3">
                    <div class="card">
                        <div class="card-body learning-card">
                            <p class="card-text">Accomplished Goals</p>
                            <h6 class="card-title learn-lext">Celebrate your academic achievements as we help you reach
                                milestones and
                                succeed in your studies.</h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid gtco-testimonials">
        <div class="container">
            <h2>Customer Testimonials Spotlight</h2>
            <div class="owl-carousel owl-carousel1 owl-theme">
                <div>
                    <div class="card text-center"><img class="card-img-top"
                            src="{{ asset('front/images/customer1.jpg') }}" alt="">
                        <div class="card-body">
                            <h5>Satisfied Customer <br />

                            </h5>
                            <p class="card-text">“ Griva Services helped me tremendously with my dissertation. The quality
                                of their assistance exceeded my expectations, and I couldn't be happier with the results.
                                Highly recommend! ” </p>
                        </div>
                    </div>
                </div>
                <div>
                    <div class="card text-center"><img class="card-img-top"
                            src="{{ asset('front/images/customer2.jpg') }}" alt="">
                        <div class="card-body">
                            <h5>Impressed Student<br />

                            </h5>
                            <p class="card-text">“ I've used Griva Services for multiple assignments, and they've
                                consistently delivered top-notch results. Their efficient communication and timely delivery
                                make them my go-to for academic assistance. ” </p>
                        </div>
                    </div>
                </div>
                <div>
                    <div class="card text-center"><img class="card-img-top"
                            src="{{ asset('front/images/Delighted-User.jpeg') }}" alt="">
                        <div class="card-body">
                            <h5>Delighted User<br />

                            </h5>
                            <p class="card-text">“ The team at Griva Services provided exceptional support throughout my
                                research project. Their expertise and guidance were invaluable, and I'm grateful for their
                                assistance. ” </p>
                        </div>
                    </div>
                </div>
                <div>
                    <div class="card text-center"><img class="card-img-top"
                            src="{{ asset('front/images/Happy-Client.jpeg') }}" alt="">
                        <div class="card-body">
                            <h5>Happy Client<br />

                            </h5>
                            <p class="card-text">“ "I've been using Griva Services for proofreading my academic papers, and
                                they've always delivered impeccable results. Their attention to detail and professionalism
                                are unmatched. ” </p>
                        </div>
                    </div>
                </div>
                <div>
                    <div class="card text-center"><img class="card-img-top"
                            src="{{ asset('front/images/Content-Customer.jpeg') }}" alt="">
                        <div class="card-body">
                            <h5>Content Customer<br />

                            </h5>
                            <p class="card-text">“ Griva Services has been instrumental in helping me improve my essay
                                writing skills. Their expert guidance and feedback have significantly boosted my grades.
                                Thank you! ” </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid gtco-features-list">
        <div class="container">
            <div class="row">
                <div class="media col-md-6 col-lg-4">
                    <div class="oval mr-4"><img class="align-self-start"
                            src="{{ asset('front/images/quality-results.png') }}" alt=""></div>
                    <div class="media-body">
                        <h5 class="mb-0">Tailored Academic Support</h5>
                        Benefit from over 6 years of industry expertise, ensuring precise guidance from seasoned
                        professionals at competitive prices.
                    </div>
                </div>
                <div class="media col-md-6 col-lg-4">
                    <div class="oval mr-4"><img class="align-self-start" src="{{ asset('front/images/analytics.png') }}"
                            alt=""></div>
                    <div class="media-body">
                        <h5 class="mb-0">Expert Feedback and Guidance</h5>
                        Confidentially submit your work for constructive feedback from our experienced tutors, avoiding
                        frustration and enhancing your academic performance effectively.
                    </div>
                </div>
                <div class="media col-md-6 col-lg-4">
                    <div class="oval mr-4"><img class="align-self-start"
                            src="{{ asset('front/images/affordable-pricing.png') }}" alt=""></div>
                    <div class="media-body">
                        <h5 class="mb-0">Innovative Tech Solutions</h5>
                        Leverage cutting-edge web and mobile platforms for learning, teaching, and writing, ensuring success
                        through effective technology integration.
                    </div>
                </div>
                <div class="media col-md-6 col-lg-4">
                    <div class="oval mr-4"><img class="align-self-start"
                            src="{{ asset('front/images/easy-to-use.png') }}" alt=""></div>
                    <div class="media-body">
                        <h5 class="mb-0">Master Data Analysis Techniques</h5>
                        Unlock the secrets of effective data analysis with guidance from proficient experts, enhancing your
                        analytical skills for academic success.

                    </div>
                </div>
                <div class="media col-md-6 col-lg-4">
                    <div class="oval mr-4"><img class="align-self-start"
                            src="{{ asset('front/images/free-support.png') }}" alt=""></div>
                    <div class="media-body">
                        <h5 class="mb-0">Effortless Assignment Tracking</h5>
                        Seamlessly monitor assignment progress through our live tracking system, eliminating the need for
                        constant emails or phone calls.
                    </div>
                </div>
                <div class="media col-md-6 col-lg-4">
                    <div class="oval mr-4"><img class="align-self-start"
                            src="{{ asset('front/images/effectively-increase.png') }}" alt=""></div>
                    <div class="media-body">
                        <h5 class="mb-0">Comprehensive Essay Assistance</h5>
                        Receive comprehensive assistance in essay writing, from structuring to polishing, ensuring top-notch
                        academic standards and success.
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- <div class="container-fluid gtco-logo-area">
        <div class="container">
            <div class="row">
                <div class="col"><img src="{{ asset('front/images/Tailored-Academic-Support.png') }}" class="img-fluid couuse-logo-img" alt="">
                </div>
                <div class="col"><img src="{{ asset('front/images/logo2.png') }}" class="img-fluid couuse-logo-img" alt="">
                </div>
                <div class="col"><img src="{{ asset('front/images/logo3.png') }}" class="img-fluid couuse-logo-img" alt="">
                </div>
                <div class="col"><img src="{{ asset('front/images/logo4.png') }}" class="img-fluid couuse-logo-img" alt="">
                </div>
                <div class="col"><img src="{{ asset('front/images/logo5.png') }}" class="img-fluid couuse-logo-img" alt="">
                </div>
            </div>
        </div>
    </div> --}}
    <div class="container-fluid gtco-news" id="news">
        <div class="container">
            <h2>Latest Course & Assignment</h2>
            <div class="owl-carousel owl-carousel2 owl-theme">
                @foreach ($latest as $item)
                    <div>
                        <div class="card text-center"><img class="card-img-top course-img"
                                src="{{ asset($item->image) }}" alt="">
                            <div class="card-body text-left pr-0 pl-0">
                                <h5 class="three-dot">{{ $item->title }} </h5>
                                <p class="card-text three-dot">{!! substr($item->description, 0, 100) !!} </p>
                                <a href="{{ route('details', ['type' => 'assignment', 'slug' => $item->slug]) }}">READ MORE
                                    <i class="fa fa-angle-right" aria-hidden="true"></i></a>
                            </div>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    </div>
@endsection


@push('styles')
    <style>
        @media (max-width: 768px) {
            .learning-card {
                padding: 0.65rem;
            }

            .learn-lext {
                font-size: 4px;
            }
        }
    </style>
@endpush
