@extends('layouts.app')

@section('content')
    <div class="container-fluid">
        <div class="container-fluid gtco-news" id="news">
            <div class="container">
                <h2> {{ $data->name }} </h2>

                <div class="content-wrapper">
                    <div class="content-image">
                        <img class="card-img-top assignmt-img" src="{{ asset($data->image) }}" alt="">
                    </div>
                     <div class="content-description">
                        
                        <div class="content-description-text">
                            {!! $data->description !!}
                        </div>
                    </div> 
                </div>


                <div class="container-fluid gtco-news" id="news">
                    <div class="container">
                        <h2> Latest Assignments </h2>
                        <div class="owl-carousel owl-carousel2 owl-theme">
                            @foreach ($latest as $item)
                                <div>
                                    <div class="card text-center"><img class="card-img-top lat-assign-img"
                                            src="{{ asset($item->image) }}" alt="">
                                        <div class="card-body text-left pr-0 pl-0">
                                            <h5 class="three-dot"> {{ $item->name }} </h5>
                                            <p class="card-text three-dot">{!! substr($item->description, 0, 50) !!}</p>
                                            <a href="{{ route('details',['type' => 'assignment', 'slug' => $item->slug]) }}">READ
                                                MORE <i class="fa fa-angle-right" aria-hidden="true"></i></a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .assignmt-img {
            height: 50%;
            width: 50%;
        }

        .content-description {
            flex: 1;
        }

        .lat-assign-img {
            height: 236px !important;
            width: 330px !important;
        }

        .content-image {
            text-align: center;
        }

        .additional-details {
            background-color: #f9f9f9;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
        }

        .additional-details h5 {
            margin-top: 0;
            margin-bottom: 15px;
            text-align: center;
        }

        .additional-details ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .additional-details li {
            margin-bottom: 10px;
            font-size: 16px;
            line-height: 1.5;
            display: inline-block;
            padding: 0px 10px;
        }

        .additional-details li strong {
            margin-right: 10px;
            /* Add spacing between label and value */
        }

        .content-description {
            flex: 1;
        }

        .content-description-text {
            margin-top: 20px;
            /* Add spacing between additional details and description */
        }

        .additional-details a {
            color: #007bff;
            text-decoration: none;
        }

        .additional-details a:hover {
            text-decoration: underline;
        }
    </style>
@endpush
