@extends('layouts.app')

@section('content')
    <div class="container-fluid">
        <div class="container-fluid gtco-news" id="news">
            <div class="container">
                <h2>All Latest Assignments</h2>

                <form action="{{ route('data', 'assignment') }}" method="GET" style="box-shadow:0 0 10px  lightgrey"
                    class="p-4">
                    <div class="from-group  row">
                        @php
                            $categories = App\Models\Category::whereStatus('1')->whereType('assignment')->get();

                            $category_id = request()->query('category_id') ?: request()->segment(3);
                            $subcategory_id = request()->query('subcategory_id') ?: request()->segment(4);

                        @endphp


                        <div class="col-3">
                            <select name="category_id" id="category_id" class="form-control">
                                @if ($categories->isEmpty())
                                    <option value="" disabled>No categories available</option>
                                @else
                                    <option value="" {{ $category_id == null ? 'selected' : '' }}>All Category
                                    </option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}"
                                            {{ $category_id == $category->id ? 'selected' : '' }}>{{ $category->name }}
                                        </option>
                                    @endforeach
                                @endif
                            </select>
                        </div>


                        <div class="col-3">
                            <select name="subcategory_id" id="subcategory_id" class="form-control">
                                <option value="" {{ $subcategory_id == null ? 'selected' : '' }}>All Subcategory
                                </option>
                                @if (subcategoryList($category_id)->isEmpty())
                                    <option value="" disabled>No subcategories available</option>
                                @else
                                    @foreach (subcategoryList($category_id) as $subcategory)
                                        <option value="{{ $subcategory->id }}"
                                            {{ $subcategory_id == $subcategory->id ? 'selected' : '' }}>
                                            {{ $subcategory->name }}
                                        </option>
                                    @endforeach
                                @endif
                            </select>
                        </div>



                        <div class="col-4">
                            <input type="text" name="search" class="form-control" placeholder="Search assignments here"
                                value="{{ isset($_GET['search']) ? $_GET['search'] : '' }}">
                        </div>
                        <div class="col-2">
                            <button type="submit" class="btn  w-100"> Search</button>
                        </div>
                    </div>
                </form>

                @if ($data->isEmpty())
                    <div class="row mt-4">
                        <div class="col-12 not-found">
                            <p>No assignments found.</p>
                        </div>
                    </div>
                @else
                    <div class="row mt-4">
                        @foreach ($data as $item)
                            <div class="col-sm-4 col-12">
                                <div>
                                    <div class="card text-center"><img class="card-img-top assignmt-img"
                                            src="{{ asset($item->image) }}" alt="">
                                        <div class="card-body text-left pr-0 pl-0">
                                            <h5 class="three-dot font-weight-bold">{{ $item->name }}</h5>
                                            <p class="three-dot card-text">{!! substr($item->description, 0, 100) !!}... </p>
                                            <a
                                                href="{{ route('details', ['type' => 'assignment', 'slug' => $item->slug]) }}">READ
                                                MORE <i class="fa fa-angle-right" aria-hidden="true"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif


            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .assignmt-img {
            width: 365px !important;
            height: 264px !important;
        }

        @media (max-width: 768px) {

            .assignmt-img {
                width: unset !important;
            }

        }

        .not-found {
            text-align: center;
        }
    </style>
@endpush

@push('scripts')
    <script src="{{ asset('front/js/jquery-3.6.0.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#category_id').on('change', function() {
                var categoryId = $(this).val();
                if (categoryId) {
                    $('#subcategory_id').html('<option value="">Loading...</option>');
                    $.ajax({
                        url: '/dashboard/subcategories/' + categoryId,
                        type: "GET",
                        dataType: "json",
                        success: function(data) {
                            $('#subcategory_id').empty();

                            $('#subcategory_id').empty().append($('<option>', {
                                value: '',
                                text: 'All Subcategories'
                            }));

                            $.each(data, function(key, value) {
                                $('#subcategory_id').append(
                                    '<option value="' + value.id +
                                    '">' + value.name + '</option>');
                            });

                        }
                    });
                } else {
                    $('#subcategory_id').empty().append($('<option>', {
                        value: '',
                        text: 'All Subcategories'
                    }));
                }
            });
        });
    </script>
@endpush
