@extends('layouts.app')

@section('content')
    <section class="divider layer-overlay overlay-white-9 mt-5" data-bg-img="images/bg/bg15.jpg"
        style="background-image: url(&quot;images/bg/bg15.jpg&quot;);">
        <div class="container pt-20 pb-20">
            <div class="row pt-10 bg-white p-5">
                <div class="col-md-12">
                    <p class="mb-0">Welcome to Griva Services, your trusted source for high-quality tutoring and research
                        support. With a team of seasoned professionals boasting over 6 years of industry experience, we
                        provide tailored guidance across diverse subjects. Whether you're seeking assistance in research,
                        proofreading, or data analysis, we offer top-notch solutions to elevate your academic performance.
                        Join us on your journey to success today.</p>
                </div>
            </div>





            @if (session('status') == 'success' && session('form_source') == 'about_us')
                <div class="alert alert-success" role="alert">
                    {{ session('message') }}
                </div>
            @endif

            <div class="row pt-10 mt-5 bg-light">

                <div class="col-md-8">
                    <h3 class="mt-0 mb-20 text-green">Send Enquiry</h3>
                    <form action="{{ route('contact-us') }}" id="contact_form" method="post">
                        @csrf
                        <input type="hidden" name="form_source" value="about_us">
                        {{-- @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                    <div>{{ old('form_source') }}</div>
                                </ul>
                            </div>
                        @endif --}}

                        <div class="row">
                            <div class="form-group col-sm-4 name"><label class="control-label"
                                    for="name">Name</label><input class="form-control" id="name" maxlength="100"
                                    name="name" placeholder="Enter Your Name*" required="" type="text"
                                    value="{{ old('form_source') == 'about_us' ? old('name') : '' }}">
                                @if ($errors->has('name') && old('form_source') == 'about_us')
                                    <span class="invalid-feedbackk" role="alert">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif

                            </div>
                            <div class="form-group col-sm-4 email"><label class="control-label"
                                    for="email">Email</label><input class="form-control" id="email" maxlength="100"
                                    name="email" placeholder="Enter Your Email*" required="" type="email"
                                    value="{{ old('form_source') == 'about_us' ? old('email') : '' }}">
                                @if ($errors->has('email') && old('form_source') == 'about_us')
                                    <span class="invalid-feedbackk" role="alert">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif

                            </div>
                            <div class="form-group col-sm-4 contact_number"><label class="control-label"
                                    for="contact_number">Contact Number</label><input class="form-control"
                                    id="contact_number" name="contact_number" placeholder="Enter contact number"
                                    required="" type="text"
                                    value="{{ old('form_source') == 'about_us' ? old('contact_number') : '' }}">

                                @if ($errors->has('contact_number') && old('form_source') == 'about_us')
                                    <span class="invalid-feedbackk" role="alert">
                                        <strong>{{ $errors->first('contact_number') }}</strong>
                                    </span>
                                @endif


                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-sm-12 description"><label class="control-label"
                                    for="id_description">Message</label>
                                <div class="form-group mb-10">
                                    <textarea class="form-control" cols="40" id="id_description" name="description" placeholder="Message..*"
                                        required="" rows="5">{{ old('form_source') == 'about_us' ? old('description') : '' }}</textarea>


                                    @if ($errors->has('description') && old('form_source') == 'about_us')
                                        <span class="invalid-feedbackk" role="alert">
                                            <strong>{{ $errors->first('description') }}</strong>
                                        </span>
                                    @endif


                                </div>
                            </div>
                        </div>
                        <div class="form-group"><button
                                style="background-image:-webkit-linear-gradient(0deg, #06c6f9 0%, #38eaf9 100%)"
                                class="submit-button btn btn-primary text-white btn-lg btn-circled"
                                type="submit">Submit</button></div>
                    </form>
                </div>
                <div class="col-md-4">
                    <div class="row">
                        <div class="col-xs-12 col-sm-6 col-md-12 text">
                            <div class="icon-box left media bg-black-333 p-25 mb-20"><span class="media-left pull-left"><i
                                        class="pe-7s-mail text-green"></i></span>
                                <div class="media-body"><br><br><strong class="text">OUR CONTACT E-MAIL</strong>

                                    <p class="mb-0">Griva services</p>
                                    <p class="mb-0">support@griva.services.com</p>
                                    <p class="mb-0">+918094997765, +447342164909</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-12 text-white">
                            <div class="icon-box left media bg-black-333 p-25 mb-20"><span class="media-left pull-left"><i
                                        class="pe-7s-map-marker text-green"></i></span>
                                <div class="media-body"><strong class="text-white">Address</strong>
                                    <p class="mb-0">2/3, Nagar Nigam Amer Road, Jaipur, 302002</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="container">
        <div class="mapouter">
            <div class="gmap_canvas"><iframe
                    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3556.4622111081003!2d75.83690538054061!3d26.952258516349186!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x396db13fb1bcbf65%3A0xb0cece4cc0c824bd!2sAmer%20Rd%2C%20Jaipur%2C%20Rajasthan%20302002!5e0!3m2!1sen!2sin!4v1711533914414!5m2!1sen!2sin"
                    frameborder="0" scrolling="no" style="width:100%; height: 450px;"></iframe>
                <style>
                    .mapouter {
                        position: relative;
                        height: 400px;
                        width: 100%;
                        background: #fff;
                    }

                    .maprouter a {
                        color: #fff !important;
                        position: absolute !important;
                        top: 0 !important;
                        z-index: 0 !important;
                    }
                </style><a href="https://blooketjoin.org">blooketjoin</a>
                <style>
                    .gmap_canvas {
                        overflow: hidden;
                        height: 400px;
                        width: 100%
                    }

                    .gmap_canvas iframe {
                        position: relative;
                        z-index: 2
                    }
                </style>
            </div>
        </div>
    </div>
@endsection
