@extends('dashboard.layouts.app')

@section('content')
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper container-xxl p-0">

            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <!-- profile -->
                        <div class="card">
                            <div class="card-header border-bottom">
                                <h4 class="card-title">Edit Sub Category</h4>
                                <a class="btn btn-primary btn-sm " href="{{ route('dashboard.subcategory') }}"> <i
                                        data-feather='eye'></i> Category list</a>

                            </div>
                            <div class="card-body py-2 my-25">
                                <!-- form -->
                                <form enctype="multipart/form-data" class="form mt-2 pt-50"
                                    action="{{ route('dashboard.subcategory.update') }}" method="post">
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $data->id }}" required>

                                    <div class="row">
                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="">Name</label>
                                            <input required type="text" class="form-control" name="name"
                                                placeholder="Name" value="{{ $data->name }}" />
                                        </div>

                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="">Category</label>
                                            <select required name="category_id" id="" class="form-select">
                                                @foreach ($categories as $item)
                                                    <option {{ $data->category_id == $item->id ? 'selected' : '' }}
                                                        value="{{ $item->id }}">
                                                        {{ $item->name }}
                                                    </option>
                                                @endforeach

                                            </select>
                                        </div>


                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="">Status</label>
                                            <select required name="status" id="" class="form-select">
                                                <option {{ $data->status == 1 ? 'selected' : '' }} value="1">
                                                    Active</option>
                                                <option {{ $data->status == 0 ? 'selected' : '' }} value="0">
                                                    Deactive</option>
                                            </select>
                                        </div>

                                        <div class="col-12">
                                            <button type="submit" class="btn btn-primary mt-1 me-1">Update</button>

                                        </div>
                                    </div>

                                </form>
                                <!--/ form -->
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- END: Content-->
@endsection
