@extends('dashboard.layouts.app')

@section('content')
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper container-xxl p-0">

            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <!-- profile -->
                        <div class="card">
                            <div class="card-header border-bottom">
                                <h4 class="card-title">Create Course</h4>
                                <a class="btn btn-primary btn-sm " href="{{ route('dashboard.course') }}"> <i
                                        data-feather='eye'></i> Course list</a>

                            </div>
                            <div class="card-body py-2 my-25">
                                <!-- form -->
                                <form enctype="multipart/form-data" class="form mt-2 pt-50"
                                    action="{{ route('dashboard.course.save') }}" method="post">
                                    @csrf
                                    <input type="hidden" name="type" value="course" required>

                                    <div class="row">
                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="">Name</label>
                                            <input required type="text" class="form-control" name="name"
                                                placeholder="name" value="{{ old('name') }}" />
                                        </div>


                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="">Image</label>
                                            <input type="file" required step="0.01" name="image"
                                                class="form-control">
                                        </div>

                                        @php
                                            $categories = App\Models\Category::whereStatus('1')
                                                ->whereType('course')
                                                ->get();
                                        @endphp

                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="category_id">Category</label>
                                            <select required name="category_id" id="category_id" class="form-select">
                                                @foreach ($categories as $category)
                                                    <option {{ old('category_id') == $category->id ? 'selected' : '' }}
                                                        value="{{ $category->id }}">
                                                        {{ $category->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="subcategory_id">Subcategory</label>
                                            <select required name="subcategory_id" id="subcategory_id" class="form-select">
                                                <option value="">Select Subcategory</option>
                                            </select>
                                        </div>


                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="">Status</label>
                                            <select required name="status" id="" class="form-select">
                                                <option {{ old('status') == '1' ? 'selected' : '' }} value="1">Active
                                                </option>
                                                <option {{ old('status') == '0' ? 'selected' : '' }} value="0">Deactive
                                                </option>
                                            </select>
                                        </div>

                                        <div class="col-12">

                                            <label class="form-label" for="">Description</label>

                                            <textarea id="description" class="form-control" name="description" rows="5" cols="50">
                                                {{ old('description') }}
                                            </textarea>

                                        </div>
                                        <div class="col-12">
                                            <button type="submit" class="btn btn-primary mt-1 me-1">Add</button>

                                        </div>
                                    </div>
                                </form>
                                <!--/ form -->
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- END: Content-->
@endsection

@push('styles')
    <link rel="stylesheet" href="https://cdn.ckeditor.com/4.23.1/standard/styles/all.css">
@endpush
@push('scripts')
    <script src="https://cdn.ckeditor.com/4.16.1/standard/ckeditor.js"></script>
    <script src="{{ asset('front/js/jquery-3.6.0.min.js') }}"></script>
    <script>
        CKEDITOR.replace('description');


        $(document).ready(function() {
            $('#category_id').on('change', function() {
                var categoryId = $(this).val();
                if (categoryId) {
                    $('#subcategory_id').html('<option value="">Loading...</option>');
                    $.ajax({
                        url: '/dashboard/subcategories/' + categoryId,
                        type: "GET",
                        dataType: "json",
                        success: function(data) {
                            $('#subcategory_id').empty();

                            $.each(data, function(key, value) {
                                $('#subcategory_id').append(
                                    '<option value="' + value.id +
                                    '">' + value.name + '</option>');
                            });



                        }
                    });
                } else {
                    $('#subcategory_id').empty();
                }
            });
        });
    </script>
@endpush
