@extends('dashboard.layouts.app')

@section('content')
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper container-xxl p-0">

            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header border-bottom">
                                <h4 class="card-title">Category</h4>
                                <a class="btn btn-primary btn-sm addBtn" href="{{ route('dashboard.category.add') }}"> <i
                                        data-feather='plus-square'></i> Create</a>
                            </div>
                            <div class="card-body py-2 my-25">
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>No.</th>
                                                <th>Name</th>
                                                <th>Type</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            @forelse($data as $item)
                                                <tr>
                                                    <td>{{ $loop->index + 1 + (request()->has('page') ? (request('page') - 1) * 10 : 0) }}
                                                    </td>
                                                    <td>{{ $item->name }}</td>
                                                    <td>{{ ucfirst($item->type) }}</td>
                                                    <td>
                                                        @if ($item->status == 1)
                                                            <span class='text-primary'>Active</span>
                                                        @else
                                                            <span class='text-warning'>Deactive</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <a href="{{ route('dashboard.category.edit', $item->id) }}"> <i
                                                                data-feather='edit'></i></a>
                                                        <a href="" class="deleteBtn" data-bs-toggle="modal"
                                                            data-bs-target="#deleteForm" data-id="{{ $item->id }}"> <i
                                                                class="text-danger" data-feather='trash'></i></a>
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="100%" align="center">NO DATA FOUND</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center">
                                {{ $data->links() }}
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- END: Content-->

    <form class="modal fade modal-primary text-start" id="deleteForm" tabindex="-1" aria-labelledby="myModalLabel120"
        aria-hidden="true" method="post" action="{{ route('dashboard.category.delete') }}">
        @csrf
        <div class="modal-dialog modal-dialog-top">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel120">Are you sure want to delete? </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" required name="id" value="" id="delete_id">
                    <div class="modal-footer d-flex justify-content-center">
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">No</button>
                        <button type="submit" class="btn btn-primary">yes</button>
                    </div>
                </div>

            </div>
        </div>
    </form>
@endsection

@section('js')
    <script>
        $('.deleteBtn').click(function() {
            $('#delete_id').val($(this).data('id'));
        });
    </script>
@endsection
