@extends('dashboard.layouts.app')

@section('content')
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper container-xxl p-0">

            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header border-bottom">
                                <h4 class="card-title">Uploaded Assignment</h4>

                            </div>
                            <div class="card-body py-2 my-25">
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>No.</th>
                                                <th>Name</th>
                                                <th>Email</th>
                                                <th>Mobile</th>
                                                <th>Assg. Title</th>
                                                <th>Deadline</th>
                                                <th>Time Zone</th>
                                                <th>File</th>
                                                <th>Date</th>
                                                <th>Words</th>
                                                <th>Description</th>

                                                <th>Action</th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            @forelse($assignments as $item)
                                                <tr>
                                                    <td>{{ $loop->index + 1 + (request()->has('page') ? (request('page') - 1) * 10 : 0) }}
                                                    </td>
                                                    <td>{{ $item->name }}</td>
                                                    <td>{{ $item->email }}</td>
                                                    <td>{{ $item->contact_number }}</td>
                                                    <td>{{ $item->assignment_title }}</td>
                                                    <td>{{ date('Y-m-d', strtotime($item->deadline)) }}</td>
                                                    <td>{{ $item->time_zone }}</td>
                                                    <td><a href="{{ asset($item->file) }}" target="_blank">View</a></td>
                                                    <td>{{ date('Y-m-d H:i:s', strtotime($item->created_at)) }}</td>


                                                    <td> <a href="#" class="word-link" data-bs-toggle="modal"
                                                            data-bs-target="#wordFullTxt" data-word="{{ $item->words }}">
                                                            {{ substr($item->words, 0, 15) . (strlen($item->words) > 15 ? '...' : '') }}</a>
                                                    </td>

                                                    <td> <a href="#" class="desc-link" data-bs-toggle="modal"
                                                            data-bs-target="#DescFullTxt"
                                                            data-desc="{{ $item->description }}">
                                                            {{ substr($item->description, 0, 15) . (strlen($item->description) > 15 ? '...' : '') }}</a>
                                                    </td>


                                                    <td>

                                                        <a href="" class="deleteBtn" data-bs-toggle="modal"
                                                            data-bs-target="#deleteForm" data-id="{{ $item->id }}"> <i
                                                                class="text-danger" data-feather='trash'></i></a>
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="100%" align="center">NO DATA FOUND</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center">
                                {{ $assignments->links() }}
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- END: Content-->

    <form class="modal fade modal-primary text-start" id="deleteForm" tabindex="-1" aria-labelledby="myModalLabel120"
        aria-hidden="true" method="post" action="{{ route('dashboard.uploaded.assignment.delete') }}">
        @csrf
        <div class="modal-dialog modal-dialog-top">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel120">Are you sure want to delete? </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" required name="id" value="" id="delete_id">
                    <div class="modal-footer d-flex justify-content-center">
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">No</button>
                        <button type="submit" class="btn btn-primary">yes</button>
                    </div>
                </div>

            </div>
        </div>
    </form>


    <div class="modal fade modal-primary text-start" id="wordFullTxt" tabindex="-1" aria-labelledby="myModalLabel120"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-top">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel120">Word Detail </h5>

                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p id="wordDetails"></p>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade modal-primary text-start" id="DescFullTxt" tabindex="-1" aria-labelledby="myModalLabel120"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-top">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel120">Description Detail </h5>

                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p id="descDetails"></p>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script>
        $('.deleteBtn').click(function() {
            $('#delete_id').val($(this).data('id'));
        });


        $(document).ready(function() {

            $('.word-link').click(function(event) {
                event.preventDefault();
                var word = $(this).data('word');
                $('#wordDetails').text(word);
            });

            $('.desc-link').click(function(event) {
                event.preventDefault();
                var desc = $(this).data('desc');
                $('#descDetails').text(desc);
            });
        });
    </script>
@endsection
