@extends('layouts.app')

@section('content')
    <div class="container-fluid">
        <div class="container-fluid gtco-news" id="news">
            <div class="container">
                <h2>Upload Your Assignment</h2>

                @if (session('status') == 'success')
                    <div class="alert alert-success" role="alert">
                        {{ session('message') }}
                    </div>
                @endif

                <div class="row pt-10 mt-5 bg-light">

                    <div class="col-md-8">
                        <h3 class="mt-0 mb-20 text-green">Personal Details</h3>
                        <form action="{{ route('assignment.upload.save') }}" id="assignment_upload" method="post"
                            enctype="multipart/form-data">
                            @csrf


                            <div class="row">
                                <div class="form-group col-sm-4 name"><label class="control-label"
                                        for="name">Name</label><input class="form-control" id="name"
                                        maxlength="100" name="name" placeholder="Your Name....." required=""
                                        type="text" value="{{ old('username') }}">
                                    @if ($errors->has('username'))
                                        <span class="invalid-feedbackk" role="alert">
                                            <strong>{{ $errors->first('username') }}</strong>
                                        </span>
                                    @endif

                                </div>
                                <div class="form-group col-sm-4 email"><label class="control-label"
                                        for="email">Email</label><input class="form-control" id="email"
                                        maxlength="100" name="email" placeholder="Your Email...." required=""
                                        type="email" value="{{ old('email') }}">
                                    @if ($errors->has('email'))
                                        <span class="invalid-feedbackk" role="alert">
                                            <strong>{{ $errors->first('email') }}</strong>
                                        </span>
                                    @endif

                                </div>
                                <div class="form-group col-sm-4 contact_number"><label class="control-label"
                                        for="contact_number">Contact Number</label><input class="form-control"
                                        id="contact_number" name="contact_number" placeholder="Enter Contact Number..."
                                        required="" type="text" value="{{ old('contact_number') }}">

                                    @if ($errors->has('contact_number'))
                                        <span class="invalid-feedbackk" role="alert">
                                            <strong>{{ $errors->first('contact_number') }}</strong>
                                        </span>
                                    @endif


                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col-sm-4 title"><label class="control-label"
                                        for="title">Title</label><input class="form-control" id="title"
                                        name="title" required type="text" placeholder="Assignment Title...">
                                    @if ($errors->has('title'))
                                        <span class="invalid-feedbackk" role="alert">
                                            <strong>{{ $errors->first('title') }}</strong>
                                        </span>
                                    @endif
                                </div>

                                <div class="form-group col-sm-4 words"><label class="control-label"
                                        for="words">Words</label><input class="form-control" id="words"
                                        name="words" required type="text" placeholder="Assignment Words...">
                                    @if ($errors->has('words'))
                                        <span class="invalid-feedbackk" role="alert">
                                            <strong>{{ $errors->first('words') }}</strong>
                                        </span>
                                    @endif
                                </div>

                                <div class="form-group col-sm-4 deadline"><label class="control-label"
                                        for="deadline">Deadline</label><input class="form-control" id="deadline"
                                        maxlength="100" name="deadline" required type="date"
                                        value="{{ old('deadline') }}">
                                    @if ($errors->has('deadline'))
                                        <span class="invalid-feedbackk" role="alert">
                                            <strong>{{ $errors->first('deadline') }}</strong>
                                        </span>
                                    @endif

                                </div>


                            </div>


                            <div class="row">

                                <div class="form-group col-sm-4 time_zone"><label class="control-label" for="time_zone">Time
                                        Zone</label><input class="form-control" id="time_zone" maxlength="100"
                                        name="time_zone" required="" type="time" value="{{ old('time_zone') }}">
                                    @if ($errors->has('time_zone'))
                                        <span class="invalid-feedbackk" role="alert">
                                            <strong>{{ $errors->first('time_zone') }}</strong>
                                        </span>
                                    @endif
                                </div>

                                <div class="form-group col-sm-4 file"><label class="control-label" for="file">Add
                                        File</label><input class="form-control" id="file" name="file" required
                                        type="file">
                                    @if ($errors->has('file'))
                                        <span class="invalid-feedbackk" role="alert">
                                            <strong>{{ $errors->first('file') }}</strong>
                                        </span>
                                    @endif
                                </div>

                            </div>


                            <div class="row">
                                <div class="form-group col-sm-12 description"><label class="control-label"
                                        for="description">Description</label>
                                    <div class="form-group mb-10">
                                        <textarea class="form-control" cols="40" id="description" name="description" placeholder="Description..*"
                                            required="" rows="5">{{ old('description') }}</textarea>


                                        @if ($errors->has('description'))
                                            <span class="invalid-feedbackk" role="alert">
                                                <strong>{{ $errors->first('description') }}</strong>
                                            </span>
                                        @endif

                                    </div>
                                </div>
                            </div>



                            <div class="form-group"><button
                                    style="background-image:-webkit-linear-gradient(0deg, #06c6f9 0%, #38eaf9 100%)"
                                    class="submit-button btn btn-primary text-white btn-lg btn-circled"
                                    type="submit">Submit</button></div>
                        </form>
                    </div>
                    <div class="col-md-4">
                        <div class="row">
                            <div class="col-xs-12 col-sm-6 col-md-12 text">
                                <ul class="offer-list">
                                    <li class="offer-item">
                                        <strong>Offer 1</strong>
                                        <ul class="discount-list">
                                            <li>5% discount on 1 Assignment</li>
                                            <li>10% discount on 2 Assignments</li>
                                            <li>15% discount on 3 Assignments</li>
                                        </ul>
                                    </li>
                                    <li class="offer-item">
                                        <strong>Offer 2</strong>
                                        <ul class="discount-list">
                                            <li>25% discount on 8 or more Assignments</li>
                                            <li>30% discount on 13 or more Assignments</li>
                                        </ul>
                                    </li>
                                    <li class="offer-item">
                                        <strong>Offer 3</strong>
                                        <ul class="discount-list">
                                            <li>20% discount on every assignment for every new student recommended by you
                                                who orders with us. Get 3 of your friends to order with us and get one
                                                assignment free.</li>
                                        </ul>
                                    </li>
                                    <li class="offer-item">
                                        <strong>Offer 4</strong>
                                        <ul class="discount-list">
                                            <li>Bring your friend to order with us. Get 15% of every order amount paid by
                                                your friend in perpetuity in your wallet.</li>
                                        </ul>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                </div>




            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .assignmt-img {
            width: 365px !important;
            height: 264px !important;
        }

        @media (max-width: 768px) {

            .assignmt-img {
                width: unset !important;
            }

        }

        .not-found {
            text-align: center;
        }

        .offer-list {
            list-style: none;
            padding-left: 0;
        }

        .offer-item {
            margin-bottom: 20px;
        }

        .discount-list {
            list-style: none;
            padding-left: 20px;
        }

        .discount-list li {
            margin-bottom: 5px;
        }

        .offer-item strong {
            font-weight: bold;
            display: block;
            margin-bottom: 10px;
            font-size: 18px;
        }
    </style>
@endpush
