
    $(function() {
        'use strict';

        var startBtn = $('#tour');

        function setupTour(tour) {
            var backBtnClass = 'btn btn-sm btn-outline-primary',
                nextBtnClass = 'btn btn-sm btn-primary btn-next';
            tour.addStep({
                title: '<span class="tour-step">01/7</span>  Budget tab',
                text: 'Quickly change between budget modules for this business unit. In Froogl, we budget revenue, cogs, wages all separately.',
                attachTo: {
                    element: '.switch-budget-input',
                    on: 'bottom'
                },
                buttons: [{
                        action: tour.cancel,
                        classes: backBtnClass,
                        text: 'Skip'
                    },
                    {
                        text: 'Next',
                        classes: nextBtnClass,
                        action: tour.next
                    }
                ]
            });

            tour.addStep({
                title: '<span class="tour-step">02/7</span>  Business units',
                text: 'Quickly change between budget modules for this business unit. In Froogl, we budget revenue, cogs, wages all separately.',
                attachTo: {
                    element: '.switch-bu-input',
                    on: 'bottom'
                },
                buttons: [{
                        action: tour.back,
                        classes: backBtnClass,
                        text: 'back'
                    },
                    {
                        action: tour.cancel,
                        classes: backBtnClass,
                        text: 'Skip'
                    },
                    {
                        text: 'Next',
                        classes: nextBtnClass,
                        action: tour.next
                    }
                ]
            });

            tour.addStep({
                title: '<span class="tour-step">03/7</span>  Scenarios',
                text: 'When budgeting you can filter between scenario cases (if they are set up). For example base case, downside case, upside case. This won’t changed the historical numbers, but it can allow the user to save different forecast growth rate assumptions for different scenarios, e.g. a high growth rate for an upside case or a low growth rate for a downside case. When viewing summary reports, the users will be able to toggle between saved scenario assumptions across the combined business.',
                attachTo: {
                    element: '.switch-scenario-input',
                    on: 'bottom'
                },
                buttons: [{
                        action: tour.back,
                        classes: backBtnClass,
                        text: 'back'
                    },
                    {
                        action: tour.cancel,
                        classes: backBtnClass,
                        text: 'Skip'
                    },
                    {
                        text: 'Next',
                        classes: nextBtnClass,
                        action: tour.next
                    }
                ]
            });

            tour.addStep({
                title: '<span class="tour-step">04/7</span>  Charts',
                text: 'This is a visual representation of historical data below, as well as the forecast assumptions assumed below. Update the numbers below to update these charts automatically.',
                attachTo: {
                    element: '.chart-tour',
                    on: 'bottom'
                },
                buttons: [{
                        action: tour.back,
                        classes: backBtnClass,
                        text: 'back'
                    },
                    {
                        action: tour.cancel,
                        classes: backBtnClass,
                        text: 'Skip'
                    },
                    {
                        text: 'Next',
                        classes: nextBtnClass,
                        action: tour.next
                    }
                ]
            });
   
            tour.addStep({
                title: '<span class="tour-step">05/7</span>  Zoom in/out ',
                text: 'If the numbers below are too small, click zoom in here. If you would like to see more columns on the screen, simply click zoom out.',
                attachTo: {
                    element: '.zoom-tour',
                    on: 'bottom'
                },
                buttons: [{
                        action: tour.back,
                        classes: backBtnClass,
                        text: 'back'
                    },
                    {
                        action: tour.cancel,
                        classes: backBtnClass,
                        text: 'Skip'
                    },
                    {
                        text: 'Next',
                        classes: nextBtnClass,
                        action: tour.next
                    }
                ]
            });


            tour.addStep({
                title: '<span class="tour-step">06/7</span>  Assumption budget',
                text: 'These are the total columns, adding up the total of all monthly data for the indicated period, either the budget forecast period or 2 years of historical actuals as comparison.',
                attachTo: {
                    element: '.total-budget-tour',
                    on: 'bottom'
                   
                },
                buttons: [{
                        action: tour.back,
                        classes: backBtnClass,
                        text: 'back'
                    },
                    {
                        action: tour.cancel,
                        classes: backBtnClass,
                        text: 'Skip'
                    },
                    {
                        text: 'Next',
                        classes: nextBtnClass,
                        action: tour.next
                    }
                ]
            });

            
            tour.addStep({
                title: '<span class="tour-step">7/7</span>  Assumtion Budget Data',
                text: 'Alternatively, the user can just overwrite any particular cell if they would prefer to budget a specific number.',
                attachTo: {
                    element: '.budget-tour',
                    on: 'bottom'
                },
                buttons: [{
                        action: tour.back,
                        classes: backBtnClass,
                        text: 'back'
                    },
                    {
                        action: tour.cancel,
                        classes: backBtnClass,
                        text: 'Skip'
                    },
                    {
                        text: 'Next',
                        classes: nextBtnClass,
                        action: tour.next
                    }
                ]
            });
   
   
   
   
            
            return tour;
        }

        if (startBtn.length) {
            startBtn.on('click', function() {
                var tourVar = new Shepherd.Tour({
                    defaultStepOptions: {
                        classes: 'shadow-md bg-purple-dark',
                        scrollTo: true,
                        cancelIcon: {
                            enabled: true
                        }
                    },
                    useModalOverlay: true
                });

                setupTour(tourVar).start();
            });
        }
    });

