/*=========================================================================================
    File Name: chart-chartjs.js
    Description: Chartjs Examples
    ----------------------------------------------------------------------------------------
    Item Name: Vuexy  - Vuejs, HTML & Laravel Admin Dashboard Template
    Author: PIXINVENT
    Author URL: http://www.themeforest.net/user/pixinvent
==========================================================================================*/

$(window).on('load', function () {
    'use strict';
  
    var chartWrapper = $('.chartjs'),
      flatPicker = $('.flat-picker'),
      barChartEx = $('.bar-chart-ex'),
      barChartEx2 = $('.bar-chart-ex-2');

  
    // Color Variables
    var primaryColorShade = '#836AF9',
      yellowColor = '#ffe800',
      successColorShade = '#28dac6',
      warningColorShade = '#ffe802',
      warningLightColor = '#FDAC34',
      infoColorShade = '#299AFF',
      greyColor = '#4F5D70',
      blueColor = '#2c9aff',
      blueLightColor = '#84D0FF',
      greyLightColor = '#EDF1F4',
      tooltipShadow = 'rgba(0, 0, 0, 0.25)',
      lineChartPrimary = '#666ee8',
      lineChartDanger = '#ff4961',
      labelColor = '#6e6b7b',
      grid_line_color = 'rgba(200, 200, 200, 0.2)'; // RGBA color helps in dark layout
  
    // Detect Dark Layout
    if ($('html').hasClass('dark-layout')) {
      labelColor = '#b4b7bd';
    }
  
    // Wrap charts with div of height according to their data-height
    if (chartWrapper.length) {
      chartWrapper.each(function () {
        $(this).wrap($('<div style="height:' + this.getAttribute('data-height') + 'px"></div>'));
      });
    }
  
    // Init flatpicker
    if (flatPicker.length) {
      var date = new Date();
      flatPicker.each(function () {
        $(this).flatpickr({
          mode: 'range',
          defaultDate: ['2019-05-01', '2019-05-10']
        });
      });
    }
  
    // Bar Chart
    // --------------------------------------------------------------------
    if (barChartEx2.length) {
      var barChartExample = new Chart(barChartEx2, {
        type: 'bar',
        options: {
          elements: {
            rectangle: {
              borderWidth: 2,
              borderSkipped: 'bottom'
            }
          },
          responsive: true,
          maintainAspectRatio: false,
          responsiveAnimationDuration: 500,
          legend: {
            display: false
          },
          tooltips: {
            // Updated default tooltip UI
            shadowOffsetX: 1,
            shadowOffsetY: 1,
            shadowBlur: 8,
            shadowColor: tooltipShadow,
            backgroundColor: window.colors.solid.white,
            titleFontColor: window.colors.solid.black,
            bodyFontColor: window.colors.solid.black
          },
          scales: {
            xAxes: [
              {
                display: true,
                gridLines: {
                  display: true,
                  color: grid_line_color,
                  zeroLineColor: grid_line_color
                },
                scaleLabel: {
                  display: false
                },
                ticks: {
                  fontColor: labelColor
                }
              }
            ],
            yAxes: [
              {
                display: true,
                gridLines: {
                  color: grid_line_color,
                  zeroLineColor: grid_line_color
                },
                ticks: {
                  stepSize: 0.5,
                  min: -1,
                  max: 1,
                  fontColor: labelColor
                }
              }
            ]
          }
        },
        data: {
          labels: ['CY19/CY20','CY20/CY21','BGT22/CY21'],
          datasets: [
            {
              data: [0,0,0],
              barThickness: 5,
              backgroundColor: successColorShade,
              borderColor: 'transparent'
            }
          ]
        }
      });
    }
  
  

    if (barChartEx.length) {
        var barChartExample = new Chart(barChartEx, {
          type: 'bar',
          options: {
            elements: {
              rectangle: {
                borderWidth: 2,
                borderSkipped: 'bottom'
              }
            },
            responsive: true,
            maintainAspectRatio: false,
            responsiveAnimationDuration: 500,
            legend: {
              display: false
            },
            tooltips: {
              // Updated default tooltip UI
              shadowOffsetX: 1,
              shadowOffsetY: 1,
              shadowBlur: 8,
              shadowColor: tooltipShadow,
              backgroundColor: window.colors.solid.white,
              titleFontColor: window.colors.solid.black,
              bodyFontColor: window.colors.solid.black
            },
            scales: {
              xAxes: [
                {
                  display: true,
                  gridLines: {
                    display: true,
                    color: grid_line_color,
                    zeroLineColor: grid_line_color
                  },
                  scaleLabel: {
                    display: false
                  },
                  ticks: {
                    fontColor: labelColor
                  }
                }
              ],
              yAxes: [
                {
                  display: true,
                  gridLines: {
                    color: grid_line_color,
                    zeroLineColor: grid_line_color
                  },
                  ticks: {
                    stepSize: 1000000,
                    min: 0,
                    max: 2000000,
                    fontColor: labelColor
                  }
                }
              ]
            }
          },
          data: {
            labels: ['CY19','CY20','CY21','BGT22'],
            datasets: [
              {
                data: [0,0,0,1000000],
                barThickness: 50,
                backgroundColor: successColorShade,
                borderColor: 'transparent'
              }
            ]
          }
        });
      }
    

   
  });
  