<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Course extends Model
{
    use HasFactory, SoftDeletes;

    protected $dates = ['deleted_at'];

    public static function getCourseBySlug($type, $slug)
    {
        return Course::whereType($type)->whereStatus('1')->whereSlug($slug)->first();
    }

    public static function getLatestRecord($type = NULL)
    {
        $query = Course::whereStatus('1')->orderBy('id', 'desc');

        if ($type !== NULL) {
            $query->whereType($type);
        }

        return $query->limit(8)->get();
    }

    public function CategoryName()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function SubcategoryName()
    {
        return $this->belongsTo(Subcategory::class, 'subcategory_id');
    }
}
