<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Contact;
use App\Models\Category;
use App\Models\Course;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $latest = Course::getLatestRecord();
        return view('home', compact('latest'));
    }

    public function about()
    {
        return view('about');
    }

    public function contact()
    {
        return view('contact');
    }

    public function course(Request $request, $type, $catid = null, $subcatid = null)
    {
        $searchQuery = $request->input('search');
        $category_id = $request->input('category_id');
        $subcategory_id = $request->input('subcategory_id');

        $query = Course::query();

        if ($searchQuery) {
            $query->where('name', 'LIKE', "%$searchQuery%")
                ->orWhere('description', 'LIKE', "%$searchQuery%");
        }


        $query->whereType($type)->whereStatus('1');

        if ($catid)
            $query->whereCategoryId($catid);
        elseif ($category_id)
            $query->whereCategoryId($category_id);


        if ($subcatid)
            $query->whereSubcategoryId($subcatid);
        elseif ($subcategory_id)
            $query->whereSubcategoryId($subcategory_id);

        $data = $query->get();

        return view($type, compact('data'));
    }

    public function courseDetails($type, $slug)
    {
        $data = Course::getCourseBySlug($type, $slug);
        $latest = Course::getLatestRecord($type);
        $detailPage = $type . 'Details';
        return view($detailPage, compact('data', 'latest'));
    }



    public function contactUs(Request $request)
    {
        $form_source =   $request->input('form_source') === 'footer' ? 'footer' : 'about_us';

        $request->validate([
            'name' => 'required|string',
            'email' => 'required|email',
            'description' => 'required|string',
            'contact_number' => 'numeric|digits_between:9,12',
            'form_source' => 'required|in:about_us,footer',
        ]);

        $table = new Contact();
        $table->name = $request->name;
        $table->email = $request->email;
        $table->description = $request->description;
        $table->contact_number = $request->contact_number;
        $table->save();

        return redirect()->back()->with(['status' => 'success', 'message' => 'Your Message has been sent successfully!', 'form_source' => $form_source]);
    }
}
