<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Course;
use App\Models\Assignment;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use App\Models\Subcategory;

class CourseController extends Controller
{

    public function Course()
    {
        $course = Course::whereType('course')->paginate(10);
        return view('dashboard.course.index', compact('course'));
    }


    public function CourseAdd()
    {

        return view('dashboard.course.add');
    }

    public function Assignment()
    {
        $assignment = Course::whereType('assignment')->paginate(10);
        return view('dashboard.assignment.index', compact('assignment'));
    }

    public function AssignmentAdd()
    {
        $course = Course::whereStatus('1')->get();
        return view('dashboard.assignment.add', compact('course'));
    }



    public function CourseSave(Request $request)
    {

        $request->validate([
            'name' => 'required|string',
            'status' => 'required|in:0,1',
            'description' => 'required|string',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'type' => 'required|in:course,assignment',
            'category_id' => 'required|exists:categories,id',
            'subcategory_id' => 'required|exists:subcategories,id',
        ]);

        $table = new Course();

        $slug = Str::slug($request->name);
        $count = Course::whereType($request->type)->whereSlug($slug)->count();
        if ($count > 0) {
            $slug = $slug . '-' . date('ymdis') . '-' . rand(0, 999);
        }


        $table->slug = $slug;
        $table->name = $request->name;
        $table->status = $request->status;
        $table->type = $request->type;
        $table->description = $request->description;
        $table->category_id = $request->category_id;
        $table->subcategory_id = $request->subcategory_id;




        if ($request->hasFile('image')) {
            $file = $request->file('image');

            $filename = time() . "_" . $file->getClientOriginalName();

            $storageDirectory = 'public/course';

            if (!Storage::exists($storageDirectory)) {
                Storage::makeDirectory($storageDirectory);
            }

            $moved = $file->storeAs($storageDirectory, $filename);

            if ($moved) {
                $imagePath = Storage::url($storageDirectory . '/' . $filename);
                $table->image = $imagePath;
            } else {
                return back()->with(['status' => 'error', 'message' => 'image not saved!']);
            }
        }

        $table->save();

        return back()->with(['status' => 'success', 'message' => 'Record Create!']);
    }




    public function CourseEdit($id)
    {
        $course = Course::findOrFail($id);
        return view('dashboard.course.edit', compact('course'));
    }

    public function AssignmentEdit($id)
    {
        $assignment = Course::findOrFail($id);
        return view('dashboard.assignment.edit', compact('assignment'));
    }

    public function CourseUpdate(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'status' => 'required|in:0,1',
            'description' => 'required|string',
            'image' => 'sometimes|nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'type' => 'required|in:course,assignment',
            'category_id' => 'required|exists:categories,id',
            'subcategory_id' => 'required|exists:subcategories,id',
        ]);

        $table = Course::findOrFail($request->id);
        $table->name = $request->name;
        $table->status = $request->status;
        $table->type = $request->type;
        $table->description = $request->description;
        $table->category_id = $request->category_id;
        $table->subcategory_id = $request->subcategory_id;


        if ($request->hasFile('image')) {
            $file = $request->file('image');

            $filename = time() . "_" . $file->getClientOriginalName();

            $storageDirectory = 'public/course';

            if (!Storage::exists($storageDirectory)) {
                Storage::makeDirectory($storageDirectory);
            }

            $moved = $file->storeAs($storageDirectory, $filename);

            if ($moved) {
                $imagePath = Storage::url($storageDirectory . '/' . $filename);
                $table->image = $imagePath;
            } else {
                return back()->with(['status' => 'error', 'message' => 'image not saved!']);
            }
        }

        $table->save();

        return back()->with(['status' => 'success', 'message' => 'Record Updated!']);
    }



    public function CourseDelete(Request $request)
    {
        $request->validate([
            'id' => 'required|integer',
        ]);

        Course::where('id', $request->id)->delete();
        return back()->with(['status' => 'success', 'message' => 'Deleted succesfully!']);
    }

    public function AssignmentUpload()
    {
        $course = Course::whereType('course')->get();
        return view('dashboard.assignment.assignment-upload', compact('course'));
    }


    public function AssignmentUploadSave(Request $request)
    {

        $request->validate([
            'name' => 'required|string',
            'email' => 'required|email',
            'contact_number' => 'numeric|digits_between:9,12',
            'description' => 'required|string',
            'file' => 'required|file|mimes:pdf,png,jpg|',
            'title' => 'required|string',
            'words' => 'required|string',
            'deadline' => 'required|date|after_or_equal:today',
            'time_zone' => 'required|after_or_equal:now',
        ]);

        $table = new Assignment();

        $table->name = $request->name;
        $table->email = $request->email;
        $table->contact_number = $request->contact_number;
        $table->description = $request->description;
        $table->assignment_title = $request->title;
        $table->words = $request->words;
        $table->deadline = $request->deadline;
        $table->time_zone = $request->time_zone;


        if ($request->hasFile('file')) {
            $file = $request->file('file');

            $filename = time() . "_" . $file->getClientOriginalName();

            $storageDirectory = 'public/assignments';

            if (!Storage::exists($storageDirectory)) {
                Storage::makeDirectory($storageDirectory);
            }

            $moved = $file->storeAs($storageDirectory, $filename);

            if ($moved) {
                $imagePath = Storage::url($storageDirectory . '/' . $filename);
                $table->file = $imagePath;
            } else {
                return back()->with(['status' => 'error', 'message' => 'file not saved!']);
            }
        }

        $table->save();

        return back()->with(['status' => 'success', 'message' => 'Your Assignment Upload Successfully!']);
    }

    public function UploadedAssignmentList()
    {
        $assignments = Assignment::paginate(10);
        return view('dashboard.assignment.uploaded-assignment-list', compact('assignments'));
    }


    public function UploadedAssignmentDelete(Request $request)
    {
        $request->validate([
            'id' => 'required|integer',
        ]);

        Assignment::where('id', $request->id)->delete();
        return back()->with(['status' => 'success', 'message' => 'Deleted succesfully!']);
    }



    public function subcategories($category_id)
    {
        $subcategories = Subcategory::where('category_id', $category_id)->get();
        return response()->json($subcategories);
    }
}
