<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Subcategory;

class CategoryController extends Controller
{
    public function Category()
    {
        try {
            $data = Category::paginate(10);
            return view('dashboard.category.index', compact('data'));
        } catch (\Exception $e) {
            return back()->with(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }

    public function CategoryAdd()
    {
        try {
            return view('dashboard.category.add');
        } catch (\Exception $e) {
            return back()->with(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }

    public function CategorySave(Request $request)
    {
        try {

            $request->validate([
                'name' => 'required|string',
                'status' => 'required|in:0,1',
                'type' => 'required|in:course,assignment',
            ]);

            $table = new Category();

            $table->name = $request->name;
            $table->status = $request->status;
            $table->type = $request->type;

            $table->save();

            return back()->with(['status' => 'success', 'message' => 'Record Create!']);
        } catch (\Exception $e) {
            return back()->with(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }

    public function CategoryEdit($id)
    {
        try {
            $data = Category::findOrFail($id);
            return view('dashboard.category.edit', compact('data'));
        } catch (\Exception $e) {
            return back()->with(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }


    public function CategoryUpdate(Request $request)
    {
        try {
            $request->validate([
                'name' => 'required|string',
                'status' => 'required|in:0,1',
                'type' => 'required|in:course,assignment',
            ]);

            $table = Category::findOrFail($request->id);
            $table->name = $request->name;
            $table->status = $request->status;
            $table->type = $request->type;

            $table->save();

            return back()->with(['status' => 'success', 'message' => 'Record Updated!']);
        } catch (\Exception $e) {
            return back()->with(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }

    public function CategoryDelete(Request $request)
    {
        try {
            $request->validate([
                'id' => 'required|integer',
            ]);

            Category::where('id', $request->id)->delete();
            return back()->with(['status' => 'success', 'message' => 'Deleted succesfully!']);
        } catch (\Exception $e) {
            return back()->with(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }


    // sub category


    public function Subcategory()
    {
        try {
            $data = Subcategory::paginate(10);

            return view('dashboard.subcategory.index', compact('data'));
        } catch (\Exception $e) {
            return back()->with(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }

    public function SubcategoryAdd()
    {
        try {
            $categories = Category::whereStatus('1')->get();
            return view('dashboard.subcategory.add', compact('categories'));
        } catch (\Exception $e) {
            return back()->with(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }

    public function SubcategorySave(Request $request)
    {
        try {

            $request->validate([
                'name' => 'required|string',
                'status' => 'required|in:0,1',
                'category_id' => 'required|exists:categories,id',
            ]);

            $table = new Subcategory();

            $table->name = $request->name;
            $table->status = $request->status;
            $table->category_id = $request->category_id;

            $table->save();

            return back()->with(['status' => 'success', 'message' => 'Record Create!']);
        } catch (\Exception $e) {
            return back()->with(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }

    public function SubcategoryEdit($id)
    {
        try {
            $data = Subcategory::findOrFail($id);
            $categories = Category::whereStatus('1')->get();
            return view('dashboard.subcategory.edit', compact('data', 'categories'));
        } catch (\Exception $e) {
            return back()->with(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }


    public function SubcategoryUpdate(Request $request)
    {
        try {
            $request->validate([
                'name' => 'required|string',
                'status' => 'required|in:0,1',
                'category_id' => 'required|exists:categories,id',
            ]);

            $table = Subcategory::findOrFail($request->id);
            $table->name = $request->name;
            $table->status = $request->status;
            $table->category_id = $request->category_id;

            $table->save();

            return back()->with(['status' => 'success', 'message' => 'Record Updated!']);
        } catch (\Exception $e) {
            return back()->with(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }

    public function SubcategoryDelete(Request $request)
    {
        try {
            $request->validate([
                'id' => 'required|integer',
            ]);

            Subcategory::where('id', $request->id)->delete();
            return back()->with(['status' => 'success', 'message' => 'Deleted succesfully!']);
        } catch (\Exception $e) {
            return back()->with(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }
}
